/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.coprocess;

import io.gitlab.jfronny.libjf.coprocess.CoProcess;

public abstract class ThreadCoProcess
implements CoProcess,
Runnable {
    private final boolean isDaemon;
    private Thread th = null;
    private boolean closed = true;

    protected ThreadCoProcess() {
        this(false);
    }

    protected ThreadCoProcess(boolean isDaemon) {
        this.isDaemon = isDaemon;
    }

    @Override
    public void start() {
        if (this.th != null) {
            this.stop();
        }
        this.closed = false;
        this.th = new Thread((Runnable)this, this.getClass().getSimpleName());
        this.th.setDaemon(this.isDaemon);
        this.th.start();
    }

    @Override
    public void stop() {
        if (this.th == null) {
            return;
        }
        this.closed = true;
        try {
            this.th.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not join co-process thread", e);
        }
        this.th = null;
    }

    @Override
    public void run() {
        while (!this.closed) {
            this.executeIteration();
        }
    }

    public abstract void executeIteration();
}

